//>>>>>>>>>>>>>>>>>>>>>>>>
//ltc2704spi.h
//ltc2704spi.c
//>>>>>>>>>>
//This file contains the send/receive functions for the LTC 2704 DAC
//The header file lists all the configuration options that can be passed in.
//


#include <mqx.h>
#include <bsp.h>

#include <ltc2704spi.h>

uint_32 send_LTC2704 (uint_8 cmd, uint_8 adr, uint_32 data, FILE_PTR spifd)
{
   uint_32 param, result;

   
   //Set up the CMD and ADR fields
   param = (cmd | adr);
   param = param << 24;
   
   //Configure the Data
   data = data << 8;
   param = param | data;
   
   
   //Send to the SPI module       
   result = fwrite (&param, 1, 3, spifd);

   /* Wait till transfer end (and deactivate CS) */
   //fflush (spifd);

   if (result == 0) 
   {
      printf ("Write FAILED! with %d\n", result);
   }
   else
   {
      printf ("OK - Sent: %d bytes of 0x%08x\n", result, param);
   }
      
   return result;
}




uint_32 send_receive_LTC2704 (uint_8 cmd, uint_8 adr, uint_32 data, FILE_PTR spifd)
{
   uint_32 param, output = 0x0000, result;
   SPI_READ_WRITE_STRUCT  rw;
   uint_8 upper_byte;
   uint_16 lower_byte;
   uint_32 msw_msb; // Most significant word containing most significant byte
   uint_32 msw_lsb; // Most significant word containing least significant byte
   uint_32 lsw_msb; // Least significant word containing most significant byte
   uint_32 lsw_lsb; // Least significant word containing least significant byte   
   
   //Set up the CMD and ADR fields
   param = (cmd | adr);
#if defined BSP_TWR_K60D100M 
   // Reverse byte ordering for Kinetis due to differences in endianness   
   lower_byte = data << 8;
   upper_byte = data >> 8;
   data = (lower_byte | upper_byte);
#else
   param = param << 24;
#endif
   
   //Configure the Data
   data = data << 8;
   param = param | data;
   
   
   
   rw.BUFFER_LENGTH = 3;
   rw.WRITE_BUFFER = (char*)&param;
   rw.READ_BUFFER = (char*)&output;
   //printf ("READ WRITE ... ");
   result = ioctl (spifd, IO_IOCTL_SPI_READ_WRITE, &rw);
#if defined BSP_TWR_K60D100M
// Re-order bytes when using Kinetis so that it displays correctly      
   msw_msb = (output & 0x000000ff) << 24;
   msw_lsb = (output & 0x0000ff00) << 8;
   lsw_msb = (output & 0x00ff0000) >> 8;
   lsw_lsb = (output & 0xff000000) >> 24;
   output = (msw_msb | msw_lsb | lsw_msb | lsw_lsb);
   
   msw_msb = (param & 0x000000ff) << 24;
   msw_lsb = (param & 0x0000ff00) << 8;
   lsw_msb = (param & 0x00ff0000) >> 8;
   lsw_lsb = (param & 0xff000000) >> 24;   
   param = (msw_msb | msw_lsb | lsw_msb | lsw_lsb);
#endif   
   //if (SPI_OK == result) 
   //{
   //   printf ("OK, sent: 0x%08x, received: 0x%08x\n", param, output);
   //} else {
   //   printf ("ERROR\n");
   // }
   //fflush (spifd);

   
   return output;
}